﻿Imports System.Text

Public Class VBMIDIForm

    Private Song As New MIDI
    Private Notes As New Collection
    Const NumberOfNotes As Integer = 128

    Private Function GetOctaveQuotes(ByVal octave As Integer) As String
        Dim octaveQuotes As New StringBuilder
        If octave < 5 Then
            octaveQuotes.Append("'", 5 - octave)
        Else
            octaveQuotes.Append("'", octave - 5)
        End If
        Return octaveQuotes.ToString
    End Function
    Private Sub AddNote(ByVal value As Integer, ByVal octave As Integer, ByVal noteName As String)
        Dim octaveQuotes As String = GetOctaveQuotes(octave)
        If octave < 5 Then
            Notes.Add(value, octaveQuotes & noteName)
        ElseIf octave > 5 Then
            Notes.Add(value, noteName & octaveQuotes)
        Else
            Notes.Add(value, noteName)
        End If

    End Sub
    Private Sub InitializeNotes()
        For i As Integer = 0 To NumberOfNotes - 1
            Dim octave As Integer = i \ 12
            Dim tone As Integer = i Mod 12

            Select Case tone
                Case 0
                    AddNote(i, octave, "C")
                    AddNote(i, octave - 1, "B#") ' A sharped B is technically in the next lower octave
                Case 1
                    AddNote(i, octave, "C#")
                    AddNote(i, octave, "Db")
                Case 2
                    AddNote(i, octave, "D")
                Case 3
                    AddNote(i, octave, "D#")
                    AddNote(i, octave, "Eb")
                Case 4
                    AddNote(i, octave, "E")
                    AddNote(i, octave, "Fb")
                Case 5
                    AddNote(i, octave, "F")
                    AddNote(i, octave, "E#")
                Case 6
                    AddNote(i, octave, "F#")
                    AddNote(i, octave, "Gb")
                Case 7
                    AddNote(i, octave, "G")
                Case 8
                    AddNote(i, octave, "G#")
                    AddNote(i, octave, "Ab")
                Case 9
                    AddNote(i, octave, "A")
                Case 10
                    AddNote(i, octave, "A#")
                    AddNote(i, octave, "Bb")
                Case 11
                    AddNote(i, octave, "B")
                    AddNote(i, octave + 1, "Cb") ' A flatted C is technically in the next higher octave
            End Select
        Next
        Notes.Add(NumberOfNotes, "R")
    End Sub
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Song.AddTrack()
        Song.AddTrack()
        Song.AddTrack()
        Song.AddTrack()

        InitializeNotes()
    End Sub

    Private Sub Save_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Save.Click

        Try
            If GenerateTrack(Track1, 0) = False And GenerateTrack(Track2, 1) = False And _
                GenerateTrack(Track3, 2) = False And GenerateTrack(Track4, 3) = False Then
                MsgBox("No tracks had valid data to write out")
                Return
            End If
        Catch ex As Exception
            ' Any errors in this function are due to bad formats -- I don't really need to check the exception type
            MsgBox("Error while saving: " & ex.Message.ToString)
            Return
        End Try

        Me.SaveMIDIDialog.DefaultExt = "MID"
        Me.SaveMIDIDialog.FileName = My.Computer.FileSystem.CombinePath(My.Computer.FileSystem.SpecialDirectories.MyDocuments, "Untitled.mid")
        Me.SaveMIDIDialog.InitialDirectory = My.Computer.FileSystem.SpecialDirectories.MyDocuments
        Me.SaveMIDIDialog.Filter = "VB MIDI files (*.MID)|*.MID"

        Dim result As DialogResult = Me.SaveMIDIDialog.ShowDialog
        If result = DialogResult.OK Then
            Song.Save(SaveMIDIDialog.FileName)
        End If

    End Sub
    Private Function GenerateTrack(ByVal trackTextBox As TextBox, ByVal index As Integer) As Boolean
        If Not Song.Tracks(index).ValidTrack Then
            Return False
        End If

        ' Translate the strings to MIDI data
        Song.Tracks(index).TrackData.Clear()

        Dim musicText As String = trackTextBox.Text

        ' Parse the string
        ' Format:  dTv, where d is the duration, T is the tone, and v is the volume.
        '   Duration:  Floating point number indicating beats of duration
        '   Tone:  '''''C through G'''''' or R (for rest)
        '   Volume: 0 through &HFF (unused for rests)
        '   Each dTv is separate by commas

        musicText = musicText.Replace(" ", "") ' Remove whitespace characters

        ' Create some "creep" counters
        Dim currentIndex As Integer = 0
        Dim count As Integer = 0
        Dim restBeats As Double = 0.0

        While currentIndex < musicText.Length() ' We should really never reach this condition unless someone terminated with a comma
            ' Step 1: Get the beats
            Dim beats As Double = 0.0
            Dim dot As Boolean = False
            While (musicText(currentIndex + count) >= "0" AndAlso musicText(currentIndex + count) <= "9") OrElse musicText(currentIndex + count) = "."
                If musicText(currentIndex + count) = "." Then
                    If dot = True Then
                        Throw New ApplicationException("Bad beat format in track " & index.ToString())
                    Else
                        dot = True
                    End If
                End If
                count += 1
            End While

            ' Now get the beats!
            If count = 0 OrElse (count = 1 AndAlso dot = True) Then
                Throw New ApplicationException("No beats found for a note in track " & index.ToString())
            End If
            beats = Double.Parse(musicText.Substring(currentIndex, count))

            ' Update counters for next round
            currentIndex = currentIndex + count
            count = 0

            ' Step 2: Get the note
            Dim note As Integer = 0
            Dim foundQuotes As Boolean = False
            While musicText(currentIndex + count) = "'"
                count += 1
                foundQuotes = True
            End While
            If (musicText(currentIndex + count) < "A" OrElse musicText(currentIndex + count) > "G") AndAlso musicText(currentIndex + count) <> "R" Then
                Throw New ApplicationException("Unrecognized note in track " & index.ToString())
            End If
            count += 1

            ' Look for flat/sharp
            If musicText(currentIndex + count) = "#" OrElse musicText(currentIndex + count) = "b" Then
                count += 1
            End If

            ' Look for quotes, but check foundQuotes as well
            While musicText(currentIndex + count) = "'"
                If foundQuotes = True Then
                    Throw New ApplicationException("Quotes on both side of a note in track " & index.ToString())
                End If
                count += 1
            End While

            ' Now translate the note!
            Dim key As String = musicText.Substring(currentIndex, count)
            note = Notes(key)

            ' Update counters for next round
            currentIndex = currentIndex + count
            count = 0

            ' Step 3: Get the volume
            Dim volume As Integer = 0
            If note <> NumberOfNotes Then ' Rests don't have volumes
                While currentIndex + count < musicText.Length() AndAlso musicText(currentIndex + count) >= "0" AndAlso musicText(currentIndex + count) <= "9"
                    count += 1
                End While

                If currentIndex = 0 Then
                    Throw New ApplicationException("No volume found for a note in track " & index.ToString())
                End If

                ' Now get the volume!
                volume = Integer.Parse(musicText.Substring(currentIndex, count))

                ' Update counters for next round
                currentIndex = currentIndex + count
                count = 0
            End If

            If note = NumberOfNotes Then
                restBeats = beats ' A rest; just have the next note start later
            Else
                Song.Tracks(index).AddNoteOnOffEvent(restBeats, MIDI.Track.NoteEvent.NoteOn, CByte(note), CByte(volume))
                Song.Tracks(index).AddNoteOnOffEvent(beats, MIDI.Track.NoteEvent.NoteOff, CByte(note), 0)
                restBeats = 0
            End If

            ' Step 4:  Check for comma
            If currentIndex >= musicText.Length Then
                Exit While ' No more notes!
            End If
            If musicText(currentIndex) = "," Then
                currentIndex += 1
            Else
                Throw New ApplicationException("Missing comma in track " & index.ToString())
            End If

        End While

        If currentIndex = 0 Then
            Return False ' Nothing got written out
        End If

        Return True
    End Function


    Private Sub Track1Channel_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) _
        Handles Track1Channel.SelectedIndexChanged, Track2Channel.SelectedIndexChanged, Track3Channel.SelectedIndexChanged, Track4Channel.SelectedIndexChanged

        Dim combo As ComboBox = CType(sender, ComboBox)
        Dim text As TextBox
        Dim index As Integer = 0
        If combo Is Track1Channel Then
            text = Track1
            index = 0
        ElseIf combo Is Track2Channel Then
            text = Track2
            index = 1
        ElseIf combo Is Track3Channel Then
            text = Track3
            index = 2
        Else
            text = Track4
            index = 3
        End If
        If combo.SelectedIndex = 0 Then
            If MsgBox("Delete all of the track information?") = MsgBoxResult.Ok Then
                text.ReadOnly = True
                text.Text = ""
                Song.Tracks(index).TrackData.Clear()
                Song.Tracks(index).Channel = -1
            Else
                ' Change the index back -- Channel must be non-zero
                combo.SelectedIndex = Song.Tracks(index).Channel - 1
            End If
        Else
            text.ReadOnly = False
            Song.Tracks(index).Channel = combo.SelectedIndex - 1
        End If
    End Sub
End Class
